package org.msh.tb.bd.dashboard.summaryrep.parser;

import org.msh.tb.bd.dashboard.DashboardIndicatorUtils;
import org.msh.tb.bd.dashboard.summaryrep.data.IndicatorRateData;
import org.msh.tb.bd.dashboard.summaryrep.data.SummaryIndicatorData;
import org.msh.utils.date.DateUtils;
import org.msh.utils.date.Period;

import java.util.Date;
import java.util.List;

/**
 * Created by mauri on 23/05/2017.
 * Parses information returned from IndicatorQuery to a SummaryIndicatorData object
 */
public class Indicator09Parser implements IndicatorParser {

    /**
     * The indicator code like 'indicator01' used by UI to generate some components
     */
    private String indicatorCode;

    public Indicator09Parser(String indicatorCode) {
        this.indicatorCode = indicatorCode;
    }

    @Override
    public SummaryIndicatorData parse(List<Object[]> result, String locationDesc) {
        Object[] o = result.get(0);

        Float rate1 = (Float) o[3];
        Float rate2 = (Float) o[6];

        SummaryIndicatorData data = new SummaryIndicatorData(locationDesc, "dashboard.last12months", "indicator09");
        data.addIndicatorRate(rate1, "%", "dashboard.indicator09.new.rate");
        data.addIndicatorRate(rate2, "%", "dashboard.indicator09.retreat.rate");

        return data;
    }

    @Override
    public Period getPeriod() {
        return DashboardIndicatorUtils.getLast12MonthsPeriod();
    }

    @Override
    public SummaryIndicatorData parse(List<Object[]> result, String locationDesc, SummaryIndicatorData nationalResult) {
        SummaryIndicatorData data = parse(result, locationDesc);

        for (IndicatorRateData rateData : data.getIndicatorRates()) {
            for (IndicatorRateData natRateData : nationalResult.getIndicatorRates()){

                if (natRateData.getRateDescMsg() != null && rateData.getRateDescMsg() != null &&
                        natRateData.getRateDescMsg().equals(rateData.getRateDescMsg())) {
                    rateData.setNationalRate(natRateData.getRate());
                    break;
                }
            }
        }

        return data;
    }

    public String getIndicatorCode() {
        return indicatorCode;
    }

    public void setIndicatorCode(String indicatorCode) {
        this.indicatorCode = indicatorCode;
    }
}
